@echo off
:: https://privacy.sexy — v0.13.8 — Sat, 11 Oct 2025 16:24:24 GMT
:: Ensure PowerShell is available
where PowerShell >nul 2>&1 || (
    echo PowerShell is not available. Please install or enable PowerShell.
    pause & exit 1
)
:: Ensure admin privileges
fltmc >nul 2>&1 || (
    echo Administrator privileges are required.
    PowerShell Start -Verb RunAs '%0' 2> nul || (
        echo Right-click on the script and select "Run as administrator".
        pause & exit 1
    )
    exit 0
)
:: Initialize environment
setlocal EnableExtensions DisableDelayedExpansion


:: ----------------------------------------------------------
:: ---------------Disable online tips (revert)---------------
:: ----------------------------------------------------------
echo --- Disable online tips (revert)
:: Delete the registry value "HKLM\SOFTWARE\Policies\Microsoft\Windows\System!AllowOnlineTips"
PowerShell -ExecutionPolicy Unrestricted -Command "reg delete 'HKLM\SOFTWARE\Policies\Microsoft\Windows\System' /v 'AllowOnlineTips' /f 2>$null"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ---Disable "Internet File Association" service (revert)---
:: ----------------------------------------------------------
echo --- Disable "Internet File Association" service (revert)
:: Delete the registry value "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Explorer!NoInternetOpenWith"
PowerShell -ExecutionPolicy Unrestricted -Command "reg delete 'HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Explorer' /v 'NoInternetOpenWith' /f 2>$null"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: -------Disable "Order Prints" picture task (revert)-------
:: ----------------------------------------------------------
echo --- Disable "Order Prints" picture task (revert)
:: Delete the registry value "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Explorer!NoOnlinePrintsWizard"
PowerShell -ExecutionPolicy Unrestricted -Command "reg delete 'HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Explorer' /v 'NoOnlinePrintsWizard' /f 2>$null"
:: ----------------------------------------------------------


:: Disable "Publish to Web" option for files and folders (revert)
echo --- Disable "Publish to Web" option for files and folders (revert)
:: Delete the registry value "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Explorer!NoPublishingWizard"
PowerShell -ExecutionPolicy Unrestricted -Command "reg delete 'HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Explorer' /v 'NoPublishingWizard' /f 2>$null"
:: ----------------------------------------------------------


:: ----------------------------------------------------------
:: ---Disable provider list downloads for wizards (revert)---
:: ----------------------------------------------------------
echo --- Disable provider list downloads for wizards (revert)
:: Delete the registry value "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Explorer!NoWebServices"
PowerShell -ExecutionPolicy Unrestricted -Command "reg delete 'HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Policies\Explorer' /v 'NoWebServices' /f 2>$null"
:: ----------------------------------------------------------


:: Pause the script to view the final state
pause
:: Restore previous environment settings
endlocal
:: Exit the script successfully
exit /b 0